// Topic view (jQuery UI widget).
(function ($) {
    $.widget('adsk.topicview', {
        options: {
            caption: "Topic"
        },

        $content: undefined,
        $header: undefined,
        $favorites: undefined,

        goToParentButtonEnabled: false,
        favoritesButtonEnabled: false,
        goBackButtonEnabled: false,

        _create: function() {
            console.log('topicview: _create');

            // Render view.
            this._render();

            // Handle UI events.
            this._addEventHandlers();
        },

        _render: function() {
            console.log('topicview: _render');

            // Create topic view markup.
            this.element.html(
              '<header class="toolbar drop-shadow">' +
                '<div class="column left">' +
                    '<a href="#" id="topic-navigation" class="navigation button icon"/>' +
                    '<a href="#" id="topic-back" class="back button icon disabled"/>' +
                    '<a href="#" id="topic-parent" class="parent button icon disabled"/>' +
                    '<a href="#" id="topic-home" class="home button icon"/>' +
                '</div>' +
                '<div class="column center"></div>' +
                '<div class="column right">' +
                    '<a href="#" id="topic-share" class="share button icon"/>' +
                    '<a href="#" id="topic-favorites" class="favorites button icon disabled"/>' +
                    '<a href="#" id="topic-search" class="search button icon"/>' +
                '</div>' +
              '</header>' +
              '<div class="content"></div>' +
              '<footer class="toolbar">' +
                '<a href="#" class="preceding-topic">' +
                  '<div class="label">Previous topic</div>' +
                  '<div class="name"></div>' +
                  '<div class="path"></div>' +
                '</a>' +
                '<a href="#" class="following-topic">' +
                  '<div class="label">Next topic</div>' +
                  '<div class="name"></div>' +
                  '<div class="path"></div>' +
                '</a>' +
              '</footer>'
            );

            // Store jQuery objects for later use.
            this.$header = this.element.find('header');
            this.$footer = this.element.find('footer');
            this.$content = this.element.find('.content');
            this.$favorites = this.element.find('#topic-favorites');
        },

        _addEventHandlers: function() {
            console.log('topicview: _addEventHandlers');

            // Add look to all tapped buttons.
            this.$header.find('.button')
            .on('touchstart', $.proxy(this._handleToolbarButtonTouchstart, this))
            .on('touchend', $.proxy(this._handleToolbarButtonTouchend, this));

            this.element
            .on('touchmove', function(event) {
                event.preventDefault();
            });

            this.$content
            .on('touchmove', function(event) {
                // Prevent bubbling to enable native scrolling.
                event.stopPropagation();
            });
        },

        _handleToolbarButtonTouchstart: function(event) {
            console.log('topicview: _handleToolbarButtonTouchstart');

            event.preventDefault();
            event.stopPropagation();

            var $target = $(event.target);

            if (!$target.hasClass('disabled')) {
                $target.addClass("tapped");
            }
        },

        _handleToolbarButtonTouchend: function(event) {
            event.preventDefault();
            event.stopPropagation();

            var $target = $(event.target);

            if (!$target.hasClass('disabled')) {
                // Style tapped button.
                $target.removeClass('tapped');

                // Trigger 'buttontap' custom event.
                this._trigger('buttontap', event, $target.attr('id'));
            }
        },

        _setContentHeight: function() {
            console.log('topicview: _setContentHeight');

            var height = $(document).height() - this.$header.height() - this.$footer.height();

            this.$content.css('height', height + 'px');
        },

        _isAbsolutePath: function(url) {
             if ((url.indexOf('http:') == 0) || (url.indexOf('https:') == 0)) {
                 return true;
             }
             return false;
        },

        _changeImageSrc: function(src, base) {
            var changedSrc = src;

            if (src && !this._isAbsolutePath(src)) {
                if (!base) {
                    base = './files/';
                }

                if (src.indexOf('../') == 0) {
                    // ../images/image.png.

                    // Strip "move up to one folder" command.
                    changedSrc = src.substr(1);
                } else {
                    // ./image.png or images.png

                    // Remove './'.
                    if (src.indexOf('./') == 0) {
                        src = src.substr(2);
                    }

                    changedSrc = base.concat(src);
                }

                return changedSrc;
            }
        },

        _changeHyperlinkHref: function(hyperlink, base) {
            var url = hyperlink.getAttribute('href'),
                changedUrl = url,
                target = hyperlink.getAttribute('target');

            if (url && !this._isAbsolutePath(url)) {
                // Not an anchor and not an absolute url.

                if (url.indexOf('../') == 0) {
                    // "Move up one folder" relative path (cases 3, 4 and 5).

                    // Strip "move up to one folder" command.
                    changedUrl = url.substr(1);

                    if (target !== '_blank') {
                         // Add hashbang (case 5).
                         changedUrl = '#!/url='.concat(changedUrl);
                    }
                } else if ((url.charAt(0) != '#') &&
                           (url.indexOf('mailto:') != 0) &&
                           (url.indexOf('javascript') != 0)) {
                    // "Current folder" relative path (topic.htm or ./topic.htm).

                    // Remove './'.
                    if (url.indexOf('./') == 0) {
                        url = url.substr(2);
                    }

                    // Add hashbang and base path (e.g. #!url=./files/topic.htm)
                    changedUrl = '#!/url='.concat(base, url);
                } else if (url == '#') {
                    changedUrl = location.hash;
                }

                hyperlink.setAttribute('href', changedUrl);
            }
        },

        /* Public members. */

        getShareButtonOffset: function() {
            console.log('topicview: getShareButtonOffset');

            var $page = this.element,
                offset = $page.find('#topic-share').offset();

            return offset;
        },

        loadPage: function(href, title, base) {
            console.log('topicview: loadPage, href = ' + href);

            var self = this;

            $container = this.element.find('.content');

            // TODO: find robust way.
            $container.html('');

            var xhr = $
            .get(href)
            .done(function(response) {
                // Replace src attribute with data-src to prevent jQuery html()
                // from triggering the browser request images.
                response = response.replace(/ src=/g, ' data-src=');

                var $bodyContent = $(response).filter('#body-content');

                if (!$bodyContent.length) {
                    $bodyContent = $(response.substring(response.indexOf("<body>"), response.indexOf("</body>") + 7));
                }

                if ($bodyContent.length) {
                    // Replace <a> elements href attribute value.
                    $bodyContent.find('a, area').each(function() {
                        self._changeHyperlinkHref(this, base);
                    });

                    // Add src attributes to <img> elements with slightly changed value of data-src attribute.
                    var images = $bodyContent.find('img');
                    images.each(function() {
                        this.setAttribute('src', self._changeImageSrc(this.getAttribute('data-src')));
                    });

                    // Add collapsible section click listener.
                    images.filter('.collapsible').click(function(event) {
                        var img = $(this);

                        img.toggleClass('opened');

                        // Show/hide collapsible section.
                        img.parents('.collapsible').find('.collapsible-section').toggleClass('hidden');
                    });

                    // Place topic content into container.
                    $container.html($bodyContent);

                    // Scroll to anchor.
                    var fragment = '';
                    if (href.lastIndexOf('#') != -1) {
                        fragment = href.substring(href.lastIndexOf('#') + 1);

                        if (fragment !== undefined && fragment !== '') {
                            var $anchor = $('a[name=' + fragment + ']');

                            console.log('scroll to fragment: ', fragment);
                            $container.scrollTo($anchor, 800);
                        }
                    }

                } else {
                    $container.html(response);
                }

                // Get topic base url.
                var splittedHref = href.split('/'),
                    baseUrl = splittedHref.slice(0, splittedHref.length - 1).join('/');

                    // Override content links and add swipe handlers.
                    self.addBodyContentHandlers(baseUrl);
                })
            .fail(function(response) {
                $container.html(response);
            })
            .always(function() {

            });
        },

        initGoToParentButton: function(enabled) {
            this.goToParentButtonEnabled = enabled;

            if (enabled) {
                this.$header.find('#topic-parent').removeClass('disabled');
            } else {
                this.$header.find('#topic-parent').addClass('disabled');
            }
        },

        initFavoritesButton: function(enabled) {
            this.favoritesButtonEnabled = enabled;

            if (enabled) {
                this.$header.find('#topic-favorites').removeClass('disabled');
            } else {
                this.$header.find('#topic-favorites').addClass('disabled');
            }
        },

        initGoBackButton: function(enabled) {
            this.goBackButtonEnabled = enabled;

            if (enabled) {
                this.$header.find('#topic-back').removeClass('disabled');
            } else {
                this.$header.find('#topic-back').addClass('disabled');
            }
        },

        resize: function() {
            console.log('topicview: resize');

            // Set content container height.
            this._setContentHeight();
        },

        // Flag if topic is in Favorites or not.
        flag: function(addedToFavorites) {
            console.log('topicview: flag');

            if (addedToFavorites) {
                this.$favorites.addClass('flagged');
            } else {
                this.$favorites.removeClass('flagged');
            }
        },

        addBodyContentHandlers: function(baseUrl) {
            console.log('topicview: addBodyContentHandlers');

            // Listen for ALL links at the top level of topic content.
            /*
            $bodyContent
            .on("click", "a", $.proxy(function(event) {
                var $target = $(event.target),
                    targetAttr = $target.attr('target');

                // For some browsers, target is undefined; for others,
                // target is false. Check for both.
                if (typeof targetAttr !== 'undefined' && targetAttr !== false) {
                    // Use default browser action.
                } else {
                    var parser = document.createElement('a');
                    parser.href = $target.attr('href');

                    var href = $target.attr('href');

                    if (location.host == parser.host) {
                        // Stop the default behavior of the browser, which
                        // is to change the URL of the page.
                        event.preventDefault();

                        // Fire event to change location hash.
                        this._trigger('opentopic', {}, {
                            href: baseUrl + '/' + href // resolve
                        });
                    } else {
                        // Use default browser action.
                    }
                }
            }, this));
            */

            this._runRetinaJS();
        },

        _runRetinaJS: function() {
            $('#body-content').find('img').retina('--2x');
        }
    });
})(jQuery);

// SIG // Begin signature block
// SIG // MIIbQQYJKoZIhvcNAQcCoIIbMjCCGy4CAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // V8IYNt/8yREf0o2EzHKm2QFjZGG3Ptp6R7oYAsYjIKqg
// SIG // ggoWMIIExzCCA6+gAwIBAgIQANMDPwr2vEKYUg3AWz9B
// SIG // yzANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xNzA2MjAwMDAw
// SIG // MDBaFw0xODA2MjAyMzU5NTlaMHgxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjENMAsGA1UECwwESVNSQzEXMBUGA1UEAwwOQXV0b2Rl
// SIG // c2ssIEluYy4wggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQDEm0ybXlDjakGjfPJQOz8JJyQPZ4frwCIk
// SIG // YuGOWfv+3NZI9Snuy2rQ00G3NuUtmIl0Y0MeypzK5A8s
// SIG // nDGR+bkcRvGn2OmMHS50aggKjsao+rCNMiC8btSwxojg
// SIG // ekzX093J9+/kauZtUESeku1KV2xsBhQ+KTc5TliNgJDJ
// SIG // kB8VW+i2bK0oVx4aMPjX8pivLnbZDYo48U5lQNJtKVBC
// SIG // tnfv0wz2QfRAvXARUxGAnn7xsdgQzYzV6wn+i6N/fMDl
// SIG // e+qWfumXUFSnueYpP85Yi3oNu5kFydgeu34/TTkF1+gD
// SIG // OXfEKLP3cInMUgL7EGTIzHlXaumXFVZobx75J77kq721
// SIG // AgMBAAGjggE+MIIBOjAJBgNVHRMEAjAAMA4GA1UdDwEB
// SIG // /wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzBhBgNV
// SIG // HSAEWjBYMFYGBmeBDAEEATBMMCMGCCsGAQUFBwIBFhdo
// SIG // dHRwczovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcC
// SIG // AjAZDBdodHRwczovL2Quc3ltY2IuY29tL3JwYTAfBgNV
// SIG // HSMEGDAWgBTUwAYiSes5S92T4lyhuEd2CXIDWDArBgNV
// SIG // HR8EJDAiMCCgHqAchhpodHRwOi8vcmIuc3ltY2IuY29t
// SIG // L3JiLmNybDBXBggrBgEFBQcBAQRLMEkwHwYIKwYBBQUH
// SIG // MAGGE2h0dHA6Ly9yYi5zeW1jZC5jb20wJgYIKwYBBQUH
// SIG // MAKGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3J0MA0G
// SIG // CSqGSIb3DQEBCwUAA4IBAQApMpNskUmvqk2ygWaCDz+3
// SIG // PTZOZl8Q1FKIoGnv2+iq6wblFUCZt+KgKKyoZoHX6GMd
// SIG // Z/YKeTi5PO4QpKQBgm82kOtKVOdUnRXhUderqaAGrX8W
// SIG // qmXjggda1kRud5e+mdcql+RV1A+RVjjVmSATbeXCC0H5
// SIG // mfvO4o5lnBOfkOQeqKxRjWdEhklOszd+1pQVFX761VyA
// SIG // GfXgr0Jtm9dptQBU1TPybl3+ypIV00IldfMGj1VOKZtd
// SIG // ZrgMiXrdaIWOqRhSEyDdQWvqGzTZm7x5elhF3vcGkRZb
// SIG // 1XqtS7OgDJ7wW0z28NMLA9yfFsPFfOQfMBEEgoCc01P9
// SIG // MBPyiz1XO28kMIIFRzCCBC+gAwIBAgIQfBs1NUrn23Tn
// SIG // QV8RacprqDANBgkqhkiG9w0BAQsFADCBvTELMAkGA1UE
// SIG // BhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8w
// SIG // HQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTow
// SIG // OAYDVQQLEzEoYykgMjAwOCBWZXJpU2lnbiwgSW5jLiAt
// SIG // IEZvciBhdXRob3JpemVkIHVzZSBvbmx5MTgwNgYDVQQD
// SIG // Ey9WZXJpU2lnbiBVbml2ZXJzYWwgUm9vdCBDZXJ0aWZp
// SIG // Y2F0aW9uIEF1dGhvcml0eTAeFw0xNDA3MjIwMDAwMDBa
// SIG // Fw0yNDA3MjEyMzU5NTlaMIGEMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAd
// SIG // BgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsxNTAz
// SIG // BgNVBAMTLFN5bWFudGVjIENsYXNzIDMgU0hBMjU2IENv
// SIG // ZGUgU2lnbmluZyBDQSAtIEcyMIIBIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAQ8AMIIBCgKCAQEA15VD1NzfZ645+1KktiYx
// SIG // BHDpt45bKro3aTWVj7vAMOeG2HO73+vRdj+KVo7rLUvw
// SIG // VxhOsY2lM9MLdSPVankn3aPT9w6HZbXerRzx9TW0IlGv
// SIG // IqHBXUuQf8BZTqudeakC1x5JsTtNh/7CeKu/71KunK8I
// SIG // 2TnlmlE+aV8wEE5xY2xY4fAgMxsPdL5byxLh24zEgJRy
// SIG // u/ZFmp7BJQv7oxye2KYJcHHswEdMj33D3hnOPu4Eco4X
// SIG // 0//wsgUyGUzTsByf/qV4IEJwQbAmjG8AyDoAEUF6QbCn
// SIG // ipEEoJl49He082Aq5mxQBLcUYP8NUfSoi4T+IdpcXn31
// SIG // KXlPsER0b21y/wIDAQABo4IBeDCCAXQwLgYIKwYBBQUH
// SIG // AQEEIjAgMB4GCCsGAQUFBzABhhJodHRwOi8vcy5zeW1j
// SIG // ZC5jb20wEgYDVR0TAQH/BAgwBgEB/wIBADBmBgNVHSAE
// SIG // XzBdMFsGC2CGSAGG+EUBBxcDMEwwIwYIKwYBBQUHAgEW
// SIG // F2h0dHBzOi8vZC5zeW1jYi5jb20vY3BzMCUGCCsGAQUF
// SIG // BwICMBkaF2h0dHBzOi8vZC5zeW1jYi5jb20vcnBhMDYG
// SIG // A1UdHwQvMC0wK6ApoCeGJWh0dHA6Ly9zLnN5bWNiLmNv
// SIG // bS91bml2ZXJzYWwtcm9vdC5jcmwwEwYDVR0lBAwwCgYI
// SIG // KwYBBQUHAwMwDgYDVR0PAQH/BAQDAgEGMCkGA1UdEQQi
// SIG // MCCkHjAcMRowGAYDVQQDExFTeW1hbnRlY1BLSS0xLTcy
// SIG // NDAdBgNVHQ4EFgQU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // HwYDVR0jBBgwFoAUtnf6aUhHn1MS1cLqBzJ2B9GXBxkw
// SIG // DQYJKoZIhvcNAQELBQADggEBAH/ryqfqi3ZC6z6OIFQw
// SIG // 47e53PpIPhbHD0WVEM0nhqNm8wLtcfiqwlWXkXCD+VJ+
// SIG // Umk8yfHglEaAGLuh1KRWpvMdAJHVhvNIh+DLxDRoIF60
// SIG // y/kF7ZyvcFMnueg+flGgaXGL3FHtgDolMp9Er25DKNMh
// SIG // dbuX2IuLjP6pBEYEhfcVnEsRjcQsF/7Vbn+a4laS8Zaz
// SIG // rS359N/aiZnOsjhEwPdHe8olufoqaDObUHLeqJ/UzSwL
// SIG // NL2LMHhA4I2OJxuQbxq+CBWBXesv4lHnUR7JeCnnHmW/
// SIG // OO8BSgEJJA4WxBR5wUE3NNA9kVKUneFo7wjw4mmcZ26Q
// SIG // CxqTcdQmAsPAWiMxghCDMIIQfwIBATCBmTCBhDELMAkG
// SIG // A1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBv
// SIG // cmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBO
// SIG // ZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAz
// SIG // IFNIQTI1NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMgIQANMD
// SIG // Pwr2vEKYUg3AWz9ByzANBglghkgBZQMEAgEFAKB8MBAG
// SIG // CisGAQQBgjcCAQwxAjAAMBkGCSqGSIb3DQEJAzEMBgor
// SIG // BgEEAYI3AgEEMBwGCisGAQQBgjcCAQsxDjAMBgorBgEE
// SIG // AYI3AgEVMC8GCSqGSIb3DQEJBDEiBCD41PVU56OicB16
// SIG // bDzBqn16ggckr80wTFg1dyWiZoLlsjANBgkqhkiG9w0B
// SIG // AQEFAASCAQCapsxMbMcVpJa+YF/nWNcE8Qu+QrMzY4/l
// SIG // On3tTNmGOoOXTuHX6SBDNxdp8g6MzoEml4tWFJIthV98
// SIG // qslSLBdpExker32Gb9znrB+KBjZbfqA5bschzCSbKcn6
// SIG // 3f0+pwluHYvQuapm7V7wlzl5QMRduLTSstaSVd3cERiG
// SIG // d+Wpl5MaLhZvdg8jcLpxk/xslNMqJSgo5PB37a4kWU/E
// SIG // omyN6dCzPh++E0tv2jRH5zxsFkNLq9ZsnTPjbDA4I8Xr
// SIG // VS4Tp4jbjygG9+erorzlxNU1G/DdmzYl8rDkhj60lZn9
// SIG // OP3eVpefxg3dRoRjrRjdYFnSPgmIY/L/JI7swi/ltWka
// SIG // oYIOPDCCDjgGCisGAQQBgjcDAwExgg4oMIIOJAYJKoZI
// SIG // hvcNAQcCoIIOFTCCDhECAQMxDTALBglghkgBZQMEAgEw
// SIG // ggEOBgsqhkiG9w0BCRABBKCB/gSB+zCB+AIBAQYLYIZI
// SIG // AYb4RQEHFwMwMTANBglghkgBZQMEAgEFAAQgvlc4K/T+
// SIG // XIE7BUbuWc+NrI3toyxRIQCLqL3rbnKp/4kCFDecIG3V
// SIG // X/qO24cuUwHLHlsSE6kSGA8yMDE4MDExNjAzMDQ0OVow
// SIG // AwIBHqCBhqSBgzCBgDELMAkGA1UEBhMCVVMxHTAbBgNV
// SIG // BAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQL
// SIG // ExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTEwLwYDVQQD
// SIG // EyhTeW1hbnRlYyBTSEEyNTYgVGltZVN0YW1waW5nIFNp
// SIG // Z25lciAtIEcyoIIKizCCBTgwggQgoAMCAQICEHsFsdRJ
// SIG // aFFE98mJ0pwZnRIwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTYwMTEyMDAw
// SIG // MDAwWhcNMzEwMTExMjM1OTU5WjB3MQswCQYDVQQGEwJV
// SIG // UzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24x
// SIG // HzAdBgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsx
// SIG // KDAmBgNVBAMTH1N5bWFudGVjIFNIQTI1NiBUaW1lU3Rh
// SIG // bXBpbmcgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQC7WZ1ZVU+djHJdGoGi61XzsAGtPHGsMo8F
// SIG // a4aaJwAyl2pNyWQUSym7wtkpuS7sY7Phzz8LVpD4Yht+
// SIG // 66YH4t5/Xm1AONSRBudBfHkcy8utG7/YlZHz8O5s+K2W
// SIG // OS5/wSe4eDnFhKXt7a+Hjs6Nx23q0pi1Oh8eOZ3D9Jqo
// SIG // 9IThxNF8ccYGKbQ/5IMNJsN7CD5N+Qq3M0n/yjvU9bKb
// SIG // S+GImRr1wOkzFNbfx4Dbke7+vJJXcnf0zajM/gn1kze+
// SIG // lYhqxdz0sUvUzugJkV+1hHk1inisGTKPI8EyQRtZDqk+
// SIG // scz51ivvt9jk1R1tETqS9pPJnONI7rtTDtQ2l4Z4xaE3
// SIG // AgMBAAGjggF3MIIBczAOBgNVHQ8BAf8EBAMCAQYwEgYD
// SIG // VR0TAQH/BAgwBgEB/wIBADBmBgNVHSAEXzBdMFsGC2CG
// SIG // SAGG+EUBBxcDMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8v
// SIG // ZC5zeW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkaF2h0
// SIG // dHBzOi8vZC5zeW1jYi5jb20vcnBhMC4GCCsGAQUFBwEB
// SIG // BCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Muc3ltY2Qu
// SIG // Y29tMDYGA1UdHwQvMC0wK6ApoCeGJWh0dHA6Ly9zLnN5
// SIG // bWNiLmNvbS91bml2ZXJzYWwtcm9vdC5jcmwwEwYDVR0l
// SIG // BAwwCgYIKwYBBQUHAwgwKAYDVR0RBCEwH6QdMBsxGTAX
// SIG // BgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTMwHQYDVR0OBBYE
// SIG // FK9j1sqjToVy4Ke8QfMpojh/gHViMB8GA1UdIwQYMBaA
// SIG // FLZ3+mlIR59TEtXC6gcydgfRlwcZMA0GCSqGSIb3DQEB
// SIG // CwUAA4IBAQB16rAt1TQZXDJF/g7h1E+meMFv1+rd3E/z
// SIG // ociBiPenjxXmQCmt5l30otlWZIRxMCrdHmEXZiBWBpgZ
// SIG // jV1x8viXvAn9HJFHyeLojQP7zJAv1gpsTjPs1rSTyEyQ
// SIG // Y0g5QCHE3dZuiZg8tZiX6KkGtwnJj1NXQZAv4R5NTtzK
// SIG // EHhsQm7wtsX4YVxS9U72a433Snq+8839A9fZ9gOoD+NT
// SIG // 9wp17MZ1LqpmhQSZt/gGV+HGDvbor9rsmxgfqrnjOgC/
// SIG // zoqUywHbnsc4uw9Sq9HjlANgCk2g/idtFDL8P5dA4b+Z
// SIG // idvkORS92uTTw+orWrOVWFUEfcea7CMDjYUq0v+uqWGB
// SIG // MIIFSzCCBDOgAwIBAgIQVFjyqtdB1kS8hKl7oJZS5jAN
// SIG // BgkqhkiG9w0BAQsFADB3MQswCQYDVQQGEwJVUzEdMBsG
// SIG // A1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAdBgNV
// SIG // BAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsxKDAmBgNV
// SIG // BAMTH1N5bWFudGVjIFNIQTI1NiBUaW1lU3RhbXBpbmcg
// SIG // Q0EwHhcNMTcwMTAyMDAwMDAwWhcNMjgwNDAxMjM1OTU5
// SIG // WjCBgDELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFu
// SIG // dGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRl
// SIG // YyBUcnVzdCBOZXR3b3JrMTEwLwYDVQQDEyhTeW1hbnRl
// SIG // YyBTSEEyNTYgVGltZVN0YW1waW5nIFNpZ25lciAtIEcy
// SIG // MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
// SIG // mfP82AQJA4b511ymk8BCfOp8Y89dAOKO88CQ348p9Rjq
// SIG // lLeS5dewoHOB6OkKm0p8Af+dj6Q5pw7qRfQiDDpw7TlF
// SIG // i+TFG1zwRWhGJAVjdpsc/J5sKrFW5Yp/UnGu8jXVRiMG
// SIG // HM9ILR20zbjZdiOOHP8+v7sGXGkHpmUO+F6ufS7tTa41
// SIG // 78nXAEL9KJUOn11yQgm8w9pE0u3MR4Tk/MotrFi+rveu
// SIG // 2UQNCLfCd9YaQ3DRbgPeUpLEEAhx2boiVfIfvO2bnTvi
// SIG // Xh1Mg/+XD3sL51WDTtIN677X7K5uR7mf36XWUbwEVe3/
// SIG // J3BMye0qSxPhsblMD8kB7lVlX2kCeGbLPwIDAQABo4IB
// SIG // xzCCAcMwDAYDVR0TAQH/BAIwADBmBgNVHSAEXzBdMFsG
// SIG // C2CGSAGG+EUBBxcDMEwwIwYIKwYBBQUHAgEWF2h0dHBz
// SIG // Oi8vZC5zeW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBka
// SIG // F2h0dHBzOi8vZC5zeW1jYi5jb20vcnBhMEAGA1UdHwQ5
// SIG // MDcwNaAzoDGGL2h0dHA6Ly90cy1jcmwud3Muc3ltYW50
// SIG // ZWMuY29tL3NoYTI1Ni10c3MtY2EuY3JsMBYGA1UdJQEB
// SIG // /wQMMAoGCCsGAQUFBwMIMA4GA1UdDwEB/wQEAwIHgDB3
// SIG // BggrBgEFBQcBAQRrMGkwKgYIKwYBBQUHMAGGHmh0dHA6
// SIG // Ly90cy1vY3NwLndzLnN5bWFudGVjLmNvbTA7BggrBgEF
// SIG // BQcwAoYvaHR0cDovL3RzLWFpYS53cy5zeW1hbnRlYy5j
// SIG // b20vc2hhMjU2LXRzcy1jYS5jZXIwKAYDVR0RBCEwH6Qd
// SIG // MBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTUwHQYD
// SIG // VR0OBBYEFAm1wf6WcpcpQ5rJ4AK6rvj9L7r2MB8GA1Ud
// SIG // IwQYMBaAFK9j1sqjToVy4Ke8QfMpojh/gHViMA0GCSqG
// SIG // SIb3DQEBCwUAA4IBAQAXswqI6VxaXiBrOwoVsmzFqYoy
// SIG // h9Ox9BxTroW+P5v/17y3lIW0x1J+lOi97WGy1KeZ5MPJ
// SIG // k8E1PQvoaApdVpi9sSI70UR617/wbVEyitUj3zgBN/bi
// SIG // Uyt6KxGPt01sejMDG3xrCZQXu+TbWNQhE2Xn7NElyix1
// SIG // mpx//Mm7KmirxH20z6PJbKfZxACciQp3kfRNovsxO4Zu
// SIG // 9uYfUAOGm7/LQqvmdptyWhEBisbvpW+V592uuuYiZfAY
// SIG // WRsRyc2At9iXRx9CCPiscR+wRlOz1LLVo6tQdUgSF4Kt
// SIG // z+BBTzJ+zZUcv5GKCD2kp2cClt8kTKXQQcCCYKOKFzJL
// SIG // 07zPpLSMMYICWjCCAlYCAQEwgYswdzELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MSgwJgYDVQQDEx9TeW1hbnRlYyBTSEEyNTYgVGltZVN0
// SIG // YW1waW5nIENBAhBUWPKq10HWRLyEqXugllLmMAsGCWCG
// SIG // SAFlAwQCAaCBpDAaBgkqhkiG9w0BCQMxDQYLKoZIhvcN
// SIG // AQkQAQQwHAYJKoZIhvcNAQkFMQ8XDTE4MDExNjAzMDQ0
// SIG // OVowLwYJKoZIhvcNAQkEMSIEIFmQD0kR2BjSJRxoDzIA
// SIG // gUooTAjFGyolaG+wq8jY2jttMDcGCyqGSIb3DQEJEAIv
// SIG // MSgwJjAkMCIEIM96wXrQR+zV/cNoIgMbEtTvB4tvK0xe
// SIG // a6Qfj/LPS61nMAsGCSqGSIb3DQEBAQSCAQACZ2zS1g6w
// SIG // pGaKYdpC1IQq/pAZXU3lDLCrsKHCgMJrECPXeK/ymxRQ
// SIG // cKBYG/dG34NS0WVwz+FkJn3OH3Cx/ZCdixh0PfYdwRwN
// SIG // rhxTRZASSEIvAoVy9NIeSmP++1ma+wr6uTD2l1YqJsUT
// SIG // jR9XN7FdksTjkUSH//DdcKzFv2JpJv0AxbLkdOEzceDi
// SIG // IZlNDEHhtZDN0RbphVPm9G8cRDflZDKVlic+nf7aFFRM
// SIG // RXLgPIycGjo23aXYRYOKGoD+jRXo8/geZz6VU4EYToD+
// SIG // qRGL1z4E3ix8dm7TViUaR7D1nymKyOOr2DhWQ6mL8J3s
// SIG // 0Q5vDe+78si1EnNlPkMslaUk
// SIG // End signature block
